##  Remote-Access VPN Overview

- Enables secure connection of individual remote users to protected resources in the internal enterprise network over the Internet.
- Uses strong authentication and cryptographic protection.
- Two main protocols for transmission protection: **SSL/TLS** and **IPsec**.
- Can support telecommuters, mobile users, and extranet users.

---

## VPN Gateways and Solutions

### Cisco Secure Firewall ASA & Threat Defense

- Both can act as VPN gateways for remote-access VPNs.
- **Cisco Secure Firewall ASA**
    - Supports both client-based and clientless VPNs (clientless deprecated from version 9.17).
- **Cisco Secure Firewall Threat Defense**
    - Supports only client-based VPNs (Cisco Secure Client/AnyConnect).

### VPN Client Options

- **Cisco Secure Client (formerly AnyConnect)**
    - Client-based solution.
    - Installed on user devices.
    - Flexible connection, reconnection, and disconnection options.
- **Clientless SSL VPN (ASA Only, Deprecated from 9.17)**
    - Browser-based access; no special client needed.
    - Supports application plug-ins and smart tunnels for broader application access.

---

## Key VPN Components

- **PC with Cisco Secure Client Installed**
    - Required for client-based VPNs.
- **Security Gateway Appliance**
    - ASA or Threat Defense with appropriate image/version.
- **Identity Certificate**
    - From a public or enterprise CA to uniquely identify the appliance.
- **User Credential Store**
    - External server (RADIUS, LDAP, Active Directory) or local user database.
- **Authentication Protocols**
    - Supported: LDAP, RADIUS, SAML (both ASA and Threat Defense), TACACS (ASA only).

---

## Deployment Requirements

### For Cisco Secure Firewall ASA

- Can use both client-based and clientless VPNs.
- Supports a wider range of authentication and authorization methods (including TACACS).
- With version 9.17+, clientless SSL VPN is deprecated and removed.

### For Cisco Secure Firewall Threat Defense

- Only supports client-based VPNs (Cisco Secure Client/AnyConnect).
- Requires:
    - PC with Cisco Secure Client configured.
    - Threat Defense image (version 6.2.2+).
    - Identity certificate.
    - User authentication via RADIUS, LDAP, Active Directory, or SAML 2.0 SSO.
- No support for clientless SSL VPN.

---

## Clientless SSL VPN (ASA Only)

- No VPN client installation required; access via web browser.
- Supports application plug-ins and smart tunnels for application access.
- Limited to supported applications; recommended for thin-client access.
- Deprecated and removed from ASA version 9.17 onward.

---

## Feature Differences: ASA vs. Threat Defense

- **Cisco Secure Firewall ASA**
    - Supports SSL, IKEv1, and IKEv2 IPsec VPNs.
    - Supports clientless and client-based VPNs.
    - Broader range of authentication (LDAP, RADIUS, SAML, TACACS, local DB).
- **Cisco Secure Firewall Threat Defense**
    - Supports SSL and IKEv2 IPsec VPNs (no IKEv1).
    - Only supports client-based VPNs (Cisco Secure Client).
    - Authentication via LDAP, RADIUS, SAML, and local DB.
    - Used for deploying Secure Client via web browser but not for clientless VPN access.

---

## Notes

- Choose VPN components and authentication methods based on the appliance capabilities, supported features, and organization security policies.
- With evolving software versions, clientless SSL VPN features may not be available or supported.